/*!
 * Bootstrap v4.0.0 (https://getbootstrap.com)
 * Copyright 2011-2018 The Bootstrap Authors (https://github.com/twbs/bootstrap/graphs/contributors)
 * Licensed under MIT (https://github.com/twbs/bootstrap/blob/master/LICENSE)
 */
(function(global,factory){typeof exports==='object'&&typeof module!=='undefined'?factory(exports,require('jquery')):typeof define==='function'&&define.amd?define(['exports','jquery'],factory):(factory((global.bootstrap={}),global.jQuery))}(this,(function(exports,$){'use strict';$=$&&$.hasOwnProperty('default')?$['default']:$;function _defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||!1;descriptor.configurable=!0;if('value' in descriptor){descriptor.writable=!0}
Object.defineProperty(target,descriptor.key,descriptor)}}
function _createClass(Constructor,protoProps,staticProps){if(protoProps){_defineProperties(Constructor.prototype,protoProps)}
if(staticProps){_defineProperties(Constructor,staticProps)}
return Constructor}
function _extends(){_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}
return target};return _extends.apply(this,arguments)}
function _inheritsLoose(subClass,superClass){subClass.prototype=Object.create(superClass.prototype);subClass.prototype.constructor=subClass;subClass.__proto__=superClass}/**
   * --------------------------------------------------------------------------
   * Bootstrap (v4.0.0): util.js
   * Licensed under MIT (https://github.com/twbs/bootstrap/blob/master/LICENSE)
   * --------------------------------------------------------------------------
   */

  var Util = function($$$1) {
    /**
     * ------------------------------------------------------------------------
     * Private TransitionEnd Helpers
     * ------------------------------------------------------------------------
     */
    var transition = false;
    var MAX_UID = 1000000; // Shoutout AngusCroll (https://goo.gl/pxwQGp)

    function toType(obj) {
      return {}.toString.call(obj).match(/\s([a-zA-Z]+)/)[1].toLowerCase();
    }

    function getSpecialTransitionEndEvent() {
      return {
        bindType    : transition.end,
        delegateType: transition.end,
        handle      : function handle(event) {
          if ($$$1(event.target).is(this)) {
            return event.handleObj.handler.apply(this, arguments); // eslint-disable-line prefer-rest-params
          }

          return undefined; // eslint-disable-line no-undefined
        }
      };
    }

    function transitionEndTest() {
      if (typeof window !== 'undefined' && window.QUnit) {
        return false;
      }

      return {
        end: 'transitionend'
      };
    }

    function transitionEndEmulator(duration) {
      var _this = this;

      var called = false;
      $$$1(this).one(Util.TRANSITION_END, function() {
        called = true;
      });
      setTimeout(function() {
        if (!called) {
          Util.triggerTransitionEnd(_this);
        }
      }, duration);
      return this;
    }

    function setTransitionEndSupport() {
      transition = transitionEndTest();
      $$$1.fn.emulateTransitionEnd = transitionEndEmulator;

      if (Util.supportsTransitionEnd()) {
        $$$1.event.special[Util.TRANSITION_END] = getSpecialTransitionEndEvent();
      }
    }

    function escapeId(selector) {
      // We escape IDs in case of special selectors (selector = '#myId:something')
      // $.escapeSelector does not exist in jQuery < 3
      selector = typeof $$$1.escapeSelector === 'function' ? $$$1.escapeSelector(selector).substr(1) : selector.replace(/(:|\.|\[|\]|,|=|@)/g, '\\$1');
      return selector;
    }

    /**
     * --------------------------------------------------------------------------
     * Public Util Api
     * --------------------------------------------------------------------------
     */


    var Util = {
      TRANSITION_END        : 'bsTransitionEnd',
      getUID                : function getUID(prefix) {
        do {
          // eslint-disable-next-line no-bitwise
          prefix += ~~(Math.random() * MAX_UID); // "~~" acts like a faster Math.floor() here
        } while (document.getElementById(prefix));

        return prefix;
      },
      getSelectorFromElement: function getSelectorFromElement(element) {
        var selector = element.getAttribute('data-target');

        if (!selector || selector === '#') {
          selector = element.getAttribute('href') || '';
        } // If it's an ID

        if (selector.charAt(0) === '#') {
          selector = escapeId(selector);
        }

        try {
          var $selector = $$$1(document).find(selector);
          return $selector.length > 0 ? selector : null;
        }
        catch (err) {
          return null;
        }
      },
      reflow                : function reflow(element) {
        return element.offsetHeight;
      },
      triggerTransitionEnd  : function triggerTransitionEnd(element) {
        $$$1(element).trigger(transition.end);
      },
      supportsTransitionEnd : function supportsTransitionEnd() {
        return Boolean(transition);
      },
      isElement             : function isElement(obj) {
        return (obj[0] || obj).nodeType;
      },
      typeCheckConfig       : function typeCheckConfig(componentName, config, configTypes) {
        for (var property in configTypes) {
          if (Object.prototype.hasOwnProperty.call(configTypes, property)) {
            var expectedTypes = configTypes[property];
            var value = config[property];
            var valueType = value && Util.isElement(value) ? 'element' : toType(value);

            if (!new RegExp(expectedTypes).test(valueType)) {
              throw new Error(componentName.toUpperCase() + ': ' + ('Option "' + property + '" provided type "' + valueType + '" ') + ('but expected type "' + expectedTypes + '".'));
            }
          }
        }
      }
    };
    setTransitionEndSupport();
    return Util;
  }($);

  /**!
   * @fileOverview Kickass library to create and place poppers near their reference elements.
   * @version 1.12.9
   * @license
   * Copyright (c) 2016 Federico Zivolo and contributors
   *
   * Permission is hereby granted, free of charge, to any person obtaining a copy
   * of this software and associated documentation files (the "Software"), to deal
   * in the Software without restriction, including without limitation the rights
   * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
   * copies of the Software, and to permit persons to whom the Software is
   * furnished to do so, subject to the following conditions:
   *
   * The above copyright notice and this permission notice shall be included in all
   * copies or substantial portions of the Software.
   *
   * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
   * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
   * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
   * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
   * SOFTWARE.
   */
var isBrowser=typeof window!=='undefined'&&typeof document!=='undefined';var longerTimeoutBrowsers=['Edge','Trident','Firefox'];var timeoutDuration=0;for(var i=0;i<longerTimeoutBrowsers.length;i+=1){if(isBrowser&&navigator.userAgent.indexOf(longerTimeoutBrowsers[i])>=0){timeoutDuration=1;break}}
function microtaskDebounce(fn){var called=!1;return function(){if(called){return}
called=!0;window.Promise.resolve().then(function(){called=!1;fn()})}}
function taskDebounce(fn){var scheduled=!1;return function(){if(!scheduled){scheduled=!0;setTimeout(function(){scheduled=!1;fn()},timeoutDuration)}}}
var supportsMicroTasks=isBrowser&&window.Promise;var debounce=supportsMicroTasks?microtaskDebounce:taskDebounce;function isFunction(functionToCheck){var getType={};return functionToCheck&&getType.toString.call(functionToCheck)==='[object Function]'}
function getStyleComputedProperty(element,property){if(element.nodeType!==1){return[]}
var css=getComputedStyle(element,null);return property?css[property]:css}
function getParentNode(element){if(element.nodeName==='HTML'){return element}
return element.parentNode||element.host}
function getScrollParent(element){if(!element){return document.body}
switch(element.nodeName){case 'HTML':case 'BODY':return element.ownerDocument.body;case '#document':return element.body}
var _getStyleComputedProp=getStyleComputedProperty(element),overflow=_getStyleComputedProp.overflow,overflowX=_getStyleComputedProp.overflowX,overflowY=_getStyleComputedProp.overflowY;if(/(auto|scroll)/.test(overflow+overflowY+overflowX)){return element}
return getScrollParent(getParentNode(element))}
function getOffsetParent(element){var offsetParent=element&&element.offsetParent;var nodeName=offsetParent&&offsetParent.nodeName;if(!nodeName||nodeName==='BODY'||nodeName==='HTML'){if(element){return element.ownerDocument.documentElement}
return document.documentElement}
if(['TD','TABLE'].indexOf(offsetParent.nodeName)!==-1&&getStyleComputedProperty(offsetParent,'position')==='static'){return getOffsetParent(offsetParent)}
return offsetParent}
function isOffsetContainer(element){var nodeName=element.nodeName;if(nodeName==='BODY'){return!1}
return nodeName==='HTML'||getOffsetParent(element.firstElementChild)===element}
function getRoot(node){if(node.parentNode!==null){return getRoot(node.parentNode)}
return node}
function findCommonOffsetParent(element1,element2){if(!element1||!element1.nodeType||!element2||!element2.nodeType){return document.documentElement}
var order=element1.compareDocumentPosition(element2)&Node.DOCUMENT_POSITION_FOLLOWING;var start=order?element1:element2;var end=order?element2:element1;var range=document.createRange();range.setStart(start,0);range.setEnd(end,0);var commonAncestorContainer=range.commonAncestorContainer;if(element1!==commonAncestorContainer&&element2!==commonAncestorContainer||start.contains(end)){if(isOffsetContainer(commonAncestorContainer)){return commonAncestorContainer}
return getOffsetParent(commonAncestorContainer)}
var element1root=getRoot(element1);if(element1root.host){return findCommonOffsetParent(element1root.host,element2)}else{return findCommonOffsetParent(element1,getRoot(element2).host)}}
function getScroll(element){var side=arguments.length>1&&arguments[1]!==undefined?arguments[1]:'top';var upperSide=side==='top'?'scrollTop':'scrollLeft';var nodeName=element.nodeName;if(nodeName==='BODY'||nodeName==='HTML'){var html=element.ownerDocument.documentElement;var scrollingElement=element.ownerDocument.scrollingElement||html;return scrollingElement[upperSide]}
return element[upperSide]}
function includeScroll(rect,element){var subtract=arguments.length>2&&arguments[2]!==undefined?arguments[2]:!1;var scrollTop=getScroll(element,'top');var scrollLeft=getScroll(element,'left');var modifier=subtract?-1:1;rect.top+=scrollTop*modifier;rect.bottom+=scrollTop*modifier;rect.left+=scrollLeft*modifier;rect.right+=scrollLeft*modifier;return rect}
function getBordersSize(styles,axis){var sideA=axis==='x'?'Left':'Top';var sideB=sideA==='Left'?'Right':'Bottom';return parseFloat(styles['border'+sideA+'Width'],10)+parseFloat(styles['border'+sideB+'Width'],10)}
var isIE10=undefined;var isIE10$1=function(){if(isIE10===undefined){isIE10=navigator.appVersion.indexOf('MSIE 10')!==-1}
return isIE10};function getSize(axis,body,html,computedStyle){return Math.max(body['offset'+axis],body['scroll'+axis],html['client'+axis],html['offset'+axis],html['scroll'+axis],isIE10$1()?html['offset'+axis]+computedStyle['margin'+(axis==='Height'?'Top':'Left')]+computedStyle['margin'+(axis==='Height'?'Bottom':'Right')]:0)}
function getWindowSizes(){var body=document.body;var html=document.documentElement;var computedStyle=isIE10$1()&&getComputedStyle(html);return{height:getSize('Height',body,html,computedStyle),width:getSize('Width',body,html,computedStyle)}}
var classCallCheck=function(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError('Cannot call a class as a function')}};var createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||!1;descriptor.configurable=!0;if('value' in descriptor){descriptor.writable=!0}
Object.defineProperty(target,descriptor.key,descriptor)}}
return function(Constructor,protoProps,staticProps){if(protoProps){defineProperties(Constructor.prototype,protoProps)}
if(staticProps){defineProperties(Constructor,staticProps)}
return Constructor}}();var defineProperty=function(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:!0,configurable:!0,writable:!0})}else{obj[key]=value}
return obj};var _extends$1=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}
return target};function getClientRect(offsets){return _extends$1({},offsets,{right:offsets.left+offsets.width,bottom:offsets.top+offsets.height})}
function getBoundingClientRect(element){var rect={};if(isIE10$1()){try{rect=element.getBoundingClientRect();var scrollTop=getScroll(element,'top');var scrollLeft=getScroll(element,'left');rect.top+=scrollTop;rect.left+=scrollLeft;rect.bottom+=scrollTop;rect.right+=scrollLeft}catch(err){}}else{rect=element.getBoundingClientRect()}
var result={left:rect.left,top:rect.top,width:rect.right-rect.left,height:rect.bottom-rect.top};var sizes=element.nodeName==='HTML'?getWindowSizes():{};var width=sizes.width||element.clientWidth||result.right-result.left;var height=sizes.height||element.clientHeight||result.bottom-result.top;var horizScrollbar=element.offsetWidth-width;var vertScrollbar=element.offsetHeight-height;if(horizScrollbar||vertScrollbar){var styles=getStyleComputedProperty(element);horizScrollbar-=getBordersSize(styles,'x');vertScrollbar-=getBordersSize(styles,'y');result.width-=horizScrollbar;result.height-=vertScrollbar}
return getClientRect(result)}
function getOffsetRectRelativeToArbitraryNode(children,parent){var isIE10=isIE10$1();var isHTML=parent.nodeName==='HTML';var childrenRect=getBoundingClientRect(children);var parentRect=getBoundingClientRect(parent);var scrollParent=getScrollParent(children);var styles=getStyleComputedProperty(parent);var borderTopWidth=parseFloat(styles.borderTopWidth,10);var borderLeftWidth=parseFloat(styles.borderLeftWidth,10);var offsets=getClientRect({top:childrenRect.top-parentRect.top-borderTopWidth,left:childrenRect.left-parentRect.left-borderLeftWidth,width:childrenRect.width,height:childrenRect.height});offsets.marginTop=0;offsets.marginLeft=0;if(!isIE10&&isHTML){var marginTop=parseFloat(styles.marginTop,10);var marginLeft=parseFloat(styles.marginLeft,10);offsets.top-=borderTopWidth-marginTop;offsets.bottom-=borderTopWidth-marginTop;offsets.left-=borderLeftWidth-marginLeft;offsets.right-=borderLeftWidth-marginLeft;offsets.marginTop=marginTop;offsets.marginLeft=marginLeft}
if(isIE10?parent.contains(scrollParent):parent===scrollParent&&scrollParent.nodeName!=='BODY'){offsets=includeScroll(offsets,parent)}
return offsets}
function getViewportOffsetRectRelativeToArtbitraryNode(element){var html=element.ownerDocument.documentElement;var relativeOffset=getOffsetRectRelativeToArbitraryNode(element,html);var width=Math.max(html.clientWidth,window.innerWidth||0);var height=Math.max(html.clientHeight,window.innerHeight||0);var scrollTop=getScroll(html);var scrollLeft=getScroll(html,'left');var offset={top:scrollTop-relativeOffset.top+relativeOffset.marginTop,left:scrollLeft-relativeOffset.left+relativeOffset.marginLeft,width:width,height:height};return getClientRect(offset)}
function isFixed(element){var nodeName=element.nodeName;if(nodeName==='BODY'||nodeName==='HTML'){return!1}
if(getStyleComputedProperty(element,'position')==='fixed'){return!0}
return isFixed(getParentNode(element))}
function getBoundaries(popper,reference,padding,boundariesElement){var boundaries={top:0,left:0};var offsetParent=findCommonOffsetParent(popper,reference);if(boundariesElement==='viewport'){boundaries=getViewportOffsetRectRelativeToArtbitraryNode(offsetParent)}else{var boundariesNode=void 0;if(boundariesElement==='scrollParent'){boundariesNode=getScrollParent(getParentNode(reference));if(boundariesNode.nodeName==='BODY'){boundariesNode=popper.ownerDocument.documentElement}}else if(boundariesElement==='window'){boundariesNode=popper.ownerDocument.documentElement}else{boundariesNode=boundariesElement}
var offsets=getOffsetRectRelativeToArbitraryNode(boundariesNode,offsetParent);if(boundariesNode.nodeName==='HTML'&&!isFixed(offsetParent)){var _getWindowSizes=getWindowSizes(),height=_getWindowSizes.height,width=_getWindowSizes.width;boundaries.top+=offsets.top-offsets.marginTop;boundaries.bottom=height+offsets.top;boundaries.left+=offsets.left-offsets.marginLeft;boundaries.right=width+offsets.left}else{boundaries=offsets}}
boundaries.left+=padding;boundaries.top+=padding;boundaries.right-=padding;boundaries.bottom-=padding;return boundaries}
function getArea(_ref){var width=_ref.width,height=_ref.height;return width*height}
function computeAutoPlacement(placement,refRect,popper,reference,boundariesElement){var padding=arguments.length>5&&arguments[5]!==undefined?arguments[5]:0;if(placement.indexOf('auto')===-1){return placement}
var boundaries=getBoundaries(popper,reference,padding,boundariesElement);var rects={top:{width:boundaries.width,height:refRect.top-boundaries.top},right:{width:boundaries.right-refRect.right,height:boundaries.height},bottom:{width:boundaries.width,height:boundaries.bottom-refRect.bottom},left:{width:refRect.left-boundaries.left,height:boundaries.height}};var sortedAreas=Object.keys(rects).map(function(key){return _extends$1({key:key},rects[key],{area:getArea(rects[key])})}).sort(function(a,b){return b.area-a.area});var filteredAreas=sortedAreas.filter(function(_ref2){var width=_ref2.width,height=_ref2.height;return width>=popper.clientWidth&&height>=popper.clientHeight});var computedPlacement=filteredAreas.length>0?filteredAreas[0].key:sortedAreas[0].key;var variation=placement.split('-')[1];return computedPlacement+(variation?'-'+variation:'')}
function getReferenceOffsets(state,popper,reference){var commonOffsetParent=findCommonOffsetParent(popper,reference);return getOffsetRectRelativeToArbitraryNode(reference,commonOffsetParent)}
function getOuterSizes(element){var styles=getComputedStyle(element);var x=parseFloat(styles.marginTop)+parseFloat(styles.marginBottom);var y=parseFloat(styles.marginLeft)+parseFloat(styles.marginRight);var result={width:element.offsetWidth+y,height:element.offsetHeight+x};return result}
function getOppositePlacement(placement){var hash={left:'right',right:'left',bottom:'top',top:'bottom'};return placement.replace(/left|right|bottom|top/g,function(matched){return hash[matched]})}
function getPopperOffsets(popper,referenceOffsets,placement){placement=placement.split('-')[0];var popperRect=getOuterSizes(popper);var popperOffsets={width:popperRect.width,height:popperRect.height};var isHoriz=['right','left'].indexOf(placement)!==-1;var mainSide=isHoriz?'top':'left';var secondarySide=isHoriz?'left':'top';var measurement=isHoriz?'height':'width';var secondaryMeasurement=!isHoriz?'height':'width';popperOffsets[mainSide]=referenceOffsets[mainSide]+referenceOffsets[measurement]/2-popperRect[measurement]/2;if(placement===secondarySide){popperOffsets[secondarySide]=referenceOffsets[secondarySide]-popperRect[secondaryMeasurement]}else{popperOffsets[secondarySide]=referenceOffsets[getOppositePlacement(secondarySide)]}
return popperOffsets}
function find(arr,check){if(Array.prototype.find){return arr.find(check)}
return arr.filter(check)[0]}
function findIndex(arr,prop,value){if(Array.prototype.findIndex){return arr.findIndex(function(cur){return cur[prop]===value})}
var match=find(arr,function(obj){return obj[prop]===value});return arr.indexOf(match)}
function runModifiers(modifiers,data,ends){var modifiersToRun=ends===undefined?modifiers:modifiers.slice(0,findIndex(modifiers,'name',ends));modifiersToRun.forEach(function(modifier){if(modifier['function']){console.warn('`modifier.function` is deprecated, use `modifier.fn`!')}
var fn=modifier['function']||modifier.fn;if(modifier.enabled&&isFunction(fn)){data.offsets.popper=getClientRect(data.offsets.popper);data.offsets.reference=getClientRect(data.offsets.reference);data=fn(data,modifier)}});return data}
function update(){if(this.state.isDestroyed){return}
var data={instance:this,styles:{},arrowStyles:{},attributes:{},flipped:!1,offsets:{}};data.offsets.reference=getReferenceOffsets(this.state,this.popper,this.reference);data.placement=computeAutoPlacement(this.options.placement,data.offsets.reference,this.popper,this.reference,this.options.modifiers.flip.boundariesElement,this.options.modifiers.flip.padding);data.originalPlacement=data.placement;data.offsets.popper=getPopperOffsets(this.popper,data.offsets.reference,data.placement);data.offsets.popper.position='absolute';data=runModifiers(this.modifiers,data);if(!this.state.isCreated){this.state.isCreated=!0;this.options.onCreate(data)}else{this.options.onUpdate(data)}}
function isModifierEnabled(modifiers,modifierName){return modifiers.some(function(_ref){var name=_ref.name,enabled=_ref.enabled;return enabled&&name===modifierName})}
function getSupportedPropertyName(property){var prefixes=[!1,'ms','Webkit','Moz','O'];var upperProp=property.charAt(0).toUpperCase()+property.slice(1);for(var i=0;i<prefixes.length-1;i++){var prefix=prefixes[i];var toCheck=prefix?''+prefix+upperProp:property;if(typeof document.body.style[toCheck]!=='undefined'){return toCheck}}
return null}
function destroy(){this.state.isDestroyed=!0;if(isModifierEnabled(this.modifiers,'applyStyle')){this.popper.removeAttribute('x-placement');this.popper.style.left='';this.popper.style.position='';this.popper.style.top='';this.popper.style[getSupportedPropertyName('transform')]=''}
this.disableEventListeners();if(this.options.removeOnDestroy){this.popper.parentNode.removeChild(this.popper)}
return this}
function getWindow(element){var ownerDocument=element.ownerDocument;return ownerDocument?ownerDocument.defaultView:window}
function attachToScrollParents(scrollParent,event,callback,scrollParents){var isBody=scrollParent.nodeName==='BODY';var target=isBody?scrollParent.ownerDocument.defaultView:scrollParent;target.addEventListener(event,callback,{passive:!0});if(!isBody){attachToScrollParents(getScrollParent(target.parentNode),event,callback,scrollParents)}
scrollParents.push(target)}
function setupEventListeners(reference,options,state,updateBound){state.updateBound=updateBound;getWindow(reference).addEventListener('resize',state.updateBound,{passive:!0});var scrollElement=getScrollParent(reference);attachToScrollParents(scrollElement,'scroll',state.updateBound,state.scrollParents);state.scrollElement=scrollElement;state.eventsEnabled=!0;return state}
function enableEventListeners(){if(!this.state.eventsEnabled){this.state=setupEventListeners(this.reference,this.options,this.state,this.scheduleUpdate)}}
function removeEventListeners(reference,state){getWindow(reference).removeEventListener('resize',state.updateBound);state.scrollParents.forEach(function(target){target.removeEventListener('scroll',state.updateBound)});state.updateBound=null;state.scrollParents=[];state.scrollElement=null;state.eventsEnabled=!1;return state}
function disableEventListeners(){if(this.state.eventsEnabled){cancelAnimationFrame(this.scheduleUpdate);this.state=removeEventListeners(this.reference,this.state)}}
function isNumeric(n){return n!==''&&!isNaN(parseFloat(n))&&isFinite(n)}
function setStyles(element,styles){Object.keys(styles).forEach(function(prop){var unit='';if(['width','height','top','right','bottom','left'].indexOf(prop)!==-1&&isNumeric(styles[prop])){unit='px'}
element.style[prop]=styles[prop]+unit})}
function setAttributes(element,attributes){Object.keys(attributes).forEach(function(prop){var value=attributes[prop];if(value!==!1){element.setAttribute(prop,attributes[prop])}else{element.removeAttribute(prop)}})}
function applyStyle(data){setStyles(data.instance.popper,data.styles);setAttributes(data.instance.popper,data.attributes);if(data.arrowElement&&Object.keys(data.arrowStyles).length){setStyles(data.arrowElement,data.arrowStyles)}
return data}
function applyStyleOnLoad(reference,popper,options,modifierOptions,state){var referenceOffsets=getReferenceOffsets(state,popper,reference);var placement=computeAutoPlacement(options.placement,referenceOffsets,popper,reference,options.modifiers.flip.boundariesElement,options.modifiers.flip.padding);popper.setAttribute('x-placement',placement);setStyles(popper,{position:'absolute'});return options}
function computeStyle(data,options){var x=options.x,y=options.y;var popper=data.offsets.popper;var legacyGpuAccelerationOption=find(data.instance.modifiers,function(modifier){return modifier.name==='applyStyle'}).gpuAcceleration;if(legacyGpuAccelerationOption!==undefined){console.warn('WARNING: `gpuAcceleration` option moved to `computeStyle` modifier and will not be supported in future versions of Popper.js!')}
var gpuAcceleration=legacyGpuAccelerationOption!==undefined?legacyGpuAccelerationOption:options.gpuAcceleration;var offsetParent=getOffsetParent(data.instance.popper);var offsetParentRect=getBoundingClientRect(offsetParent);var styles={position:popper.position};var offsets={left:Math.floor(popper.left),top:Math.floor(popper.top),bottom:Math.floor(popper.bottom),right:Math.floor(popper.right)};var sideA=x==='bottom'?'top':'bottom';var sideB=y==='right'?'left':'right';var prefixedProperty=getSupportedPropertyName('transform');var left=void 0,top=void 0;if(sideA==='bottom'){top=-offsetParentRect.height+offsets.bottom}else{top=offsets.top}
if(sideB==='right'){left=-offsetParentRect.width+offsets.right}else{left=offsets.left}
if(gpuAcceleration&&prefixedProperty){styles[prefixedProperty]='translate3d('+left+'px, '+top+'px, 0)';styles[sideA]=0;styles[sideB]=0;styles.willChange='transform'}else{var invertTop=sideA==='bottom'?-1:1;var invertLeft=sideB==='right'?-1:1;styles[sideA]=top*invertTop;styles[sideB]=left*invertLeft;styles.willChange=sideA+', '+sideB}
var attributes={'x-placement':data.placement};data.attributes=_extends$1({},attributes,data.attributes);data.styles=_extends$1({},styles,data.styles);data.arrowStyles=_extends$1({},data.offsets.arrow,data.arrowStyles);return data}
function isModifierRequired(modifiers,requestingName,requestedName){var requesting=find(modifiers,function(_ref){var name=_ref.name;return name===requestingName});var isRequired=!!requesting&&modifiers.some(function(modifier){return modifier.name===requestedName&&modifier.enabled&&modifier.order<requesting.order});if(!isRequired){var _requesting='`'+requestingName+'`';var requested='`'+requestedName+'`';console.warn(requested+' modifier is required by '+_requesting+' modifier in order to work, be sure to include it before '+_requesting+'!')}
return isRequired}
function arrow(data,options){var _data$offsets$arrow;if(!isModifierRequired(data.instance.modifiers,'arrow','keepTogether')){return data}
var arrowElement=options.element;if(typeof arrowElement==='string'){arrowElement=data.instance.popper.querySelector(arrowElement);if(!arrowElement){return data}}else{if(!data.instance.popper.contains(arrowElement)){console.warn('WARNING: `arrow.element` must be child of its popper element!');return data}}
var placement=data.placement.split('-')[0];var _data$offsets=data.offsets,popper=_data$offsets.popper,reference=_data$offsets.reference;var isVertical=['left','right'].indexOf(placement)!==-1;var len=isVertical?'height':'width';var sideCapitalized=isVertical?'Top':'Left';var side=sideCapitalized.toLowerCase();var altSide=isVertical?'left':'top';var opSide=isVertical?'bottom':'right';var arrowElementSize=getOuterSizes(arrowElement)[len];if(reference[opSide]-arrowElementSize<popper[side]){data.offsets.popper[side]-=popper[side]-(reference[opSide]-arrowElementSize)}
if(reference[side]+arrowElementSize>popper[opSide]){data.offsets.popper[side]+=reference[side]+arrowElementSize-popper[opSide]}
data.offsets.popper=getClientRect(data.offsets.popper);var center=reference[side]+reference[len]/2-arrowElementSize/2;var css=getStyleComputedProperty(data.instance.popper);var popperMarginSide=parseFloat(css['margin'+sideCapitalized],10);var popperBorderSide=parseFloat(css['border'+sideCapitalized+'Width'],10);var sideValue=center-data.offsets.popper[side]-popperMarginSide-popperBorderSide;sideValue=Math.max(Math.min(popper[len]-arrowElementSize,sideValue),0);data.arrowElement=arrowElement;data.offsets.arrow=(_data$offsets$arrow={},defineProperty(_data$offsets$arrow,side,Math.round(sideValue)),defineProperty(_data$offsets$arrow,altSide,''),_data$offsets$arrow);return data}
function getOppositeVariation(variation){if(variation==='end'){return'start'}else if(variation==='start'){return'end'}
return variation}
var placements=['auto-start','auto','auto-end','top-start','top','top-end','right-start','right','right-end','bottom-end','bottom','bottom-start','left-end','left','left-start'];var validPlacements=placements.slice(3);function clockwise(placement){var counter=arguments.length>1&&arguments[1]!==undefined?arguments[1]:!1;var index=validPlacements.indexOf(placement);var arr=validPlacements.slice(index+1).concat(validPlacements.slice(0,index));return counter?arr.reverse():arr}
var BEHAVIORS={FLIP:'flip',CLOCKWISE:'clockwise',COUNTERCLOCKWISE:'counterclockwise'};function flip(data,options){if(isModifierEnabled(data.instance.modifiers,'inner')){return data}
if(data.flipped&&data.placement===data.originalPlacement){return data}
var boundaries=getBoundaries(data.instance.popper,data.instance.reference,options.padding,options.boundariesElement);var placement=data.placement.split('-')[0];var placementOpposite=getOppositePlacement(placement);var variation=data.placement.split('-')[1]||'';var flipOrder=[];switch(options.behavior){case BEHAVIORS.FLIP:flipOrder=[placement,placementOpposite];break;case BEHAVIORS.CLOCKWISE:flipOrder=clockwise(placement);break;case BEHAVIORS.COUNTERCLOCKWISE:flipOrder=clockwise(placement,!0);break;default:flipOrder=options.behavior}
flipOrder.forEach(function(step,index){if(placement!==step||flipOrder.length===index+1){return data}
placement=data.placement.split('-')[0];placementOpposite=getOppositePlacement(placement);var popperOffsets=data.offsets.popper;var refOffsets=data.offsets.reference;var floor=Math.floor;var overlapsRef=placement==='left'&&floor(popperOffsets.right)>floor(refOffsets.left)||placement==='right'&&floor(popperOffsets.left)<floor(refOffsets.right)||placement==='top'&&floor(popperOffsets.bottom)>floor(refOffsets.top)||placement==='bottom'&&floor(popperOffsets.top)<floor(refOffsets.bottom);var overflowsLeft=floor(popperOffsets.left)<floor(boundaries.left);var overflowsRight=floor(popperOffsets.right)>floor(boundaries.right);var overflowsTop=floor(popperOffsets.top)<floor(boundaries.top);var overflowsBottom=floor(popperOffsets.bottom)>floor(boundaries.bottom);var overflowsBoundaries=placement==='left'&&overflowsLeft||placement==='right'&&overflowsRight||placement==='top'&&overflowsTop||placement==='bottom'&&overflowsBottom;var isVertical=['top','bottom'].indexOf(placement)!==-1;var flippedVariation=!!options.flipVariations&&(isVertical&&variation==='start'&&overflowsLeft||isVertical&&variation==='end'&&overflowsRight||!isVertical&&variation==='start'&&overflowsTop||!isVertical&&variation==='end'&&overflowsBottom);if(overlapsRef||overflowsBoundaries||flippedVariation){data.flipped=!0;if(overlapsRef||overflowsBoundaries){placement=flipOrder[index+1]}
if(flippedVariation){variation=getOppositeVariation(variation)}
data.placement=placement+(variation?'-'+variation:'');data.offsets.popper=_extends$1({},data.offsets.popper,getPopperOffsets(data.instance.popper,data.offsets.reference,data.placement));data=runModifiers(data.instance.modifiers,data,'flip')}});return data}
function keepTogether(data){var _data$offsets=data.offsets,popper=_data$offsets.popper,reference=_data$offsets.reference;var placement=data.placement.split('-')[0];var floor=Math.floor;var isVertical=['top','bottom'].indexOf(placement)!==-1;var side=isVertical?'right':'bottom';var opSide=isVertical?'left':'top';var measurement=isVertical?'width':'height';if(popper[side]<floor(reference[opSide])){data.offsets.popper[opSide]=floor(reference[opSide])-popper[measurement]}
if(popper[opSide]>floor(reference[side])){data.offsets.popper[opSide]=floor(reference[side])}
return data}
function toValue(str,measurement,popperOffsets,referenceOffsets){var split=str.match(/((?:\-|\+)?\d*\.?\d*)(.*)/);var value=+split[1];var unit=split[2];if(!value){return str}
if(unit.indexOf('%')===0){var element=void 0;switch(unit){case '%p':element=popperOffsets;break;case '%':case '%r':default:element=referenceOffsets}
var rect=getClientRect(element);return rect[measurement]/100*value}else if(unit==='vh'||unit==='vw'){var size=void 0;if(unit==='vh'){size=Math.max(document.documentElement.clientHeight,window.innerHeight||0)}else{size=Math.max(document.documentElement.clientWidth,window.innerWidth||0)}
return size/100*value}else{return value}}
function parseOffset(offset,popperOffsets,referenceOffsets,basePlacement){var offsets=[0,0];var useHeight=['right','left'].indexOf(basePlacement)!==-1;var fragments=offset.split(/(\+|\-)/).map(function(frag){return frag.trim()});var divider=fragments.indexOf(find(fragments,function(frag){return frag.search(/,|\s/)!==-1}));if(fragments[divider]&&fragments[divider].indexOf(',')===-1){console.warn('Offsets separated by white space(s) are deprecated, use a comma (,) instead.')}
var splitRegex=/\s*,\s*|\s+/;var ops=divider!==-1?[fragments.slice(0,divider).concat([fragments[divider].split(splitRegex)[0]]),[fragments[divider].split(splitRegex)[1]].concat(fragments.slice(divider+1))]:[fragments];ops=ops.map(function(op,index){var measurement=(index===1?!useHeight:useHeight)?'height':'width';var mergeWithPrevious=!1;return op.reduce(function(a,b){if(a[a.length-1]===''&&['+','-'].indexOf(b)!==-1){a[a.length-1]=b;mergeWithPrevious=!0;return a}else if(mergeWithPrevious){a[a.length-1]+=b;mergeWithPrevious=!1;return a}else{return a.concat(b)}},[]).map(function(str){return toValue(str,measurement,popperOffsets,referenceOffsets)})});ops.forEach(function(op,index){op.forEach(function(frag,index2){if(isNumeric(frag)){offsets[index]+=frag*(op[index2-1]==='-'?-1:1)}})});return offsets}
function offset(data,_ref){var offset=_ref.offset;var placement=data.placement,_data$offsets=data.offsets,popper=_data$offsets.popper,reference=_data$offsets.reference;var basePlacement=placement.split('-')[0];var offsets=void 0;if(isNumeric(+offset)){offsets=[+offset,0]}else{offsets=parseOffset(offset,popper,reference,basePlacement)}
if(basePlacement==='left'){popper.top+=offsets[0];popper.left-=offsets[1]}else if(basePlacement==='right'){popper.top+=offsets[0];popper.left+=offsets[1]}else if(basePlacement==='top'){popper.left+=offsets[0];popper.top-=offsets[1]}else if(basePlacement==='bottom'){popper.left+=offsets[0];popper.top+=offsets[1]}
data.popper=popper;return data}
function preventOverflow(data,options){var boundariesElement=options.boundariesElement||getOffsetParent(data.instance.popper);if(data.instance.reference===boundariesElement){boundariesElement=getOffsetParent(boundariesElement)}
var boundaries=getBoundaries(data.instance.popper,data.instance.reference,options.padding,boundariesElement);options.boundaries=boundaries;var order=options.priority;var popper=data.offsets.popper;var check={primary:function primary(placement){var value=popper[placement];if(popper[placement]<boundaries[placement]&&!options.escapeWithReference){value=Math.max(popper[placement],boundaries[placement])}
return defineProperty({},placement,value)},secondary:function secondary(placement){var mainSide=placement==='right'?'left':'top';var value=popper[mainSide];if(popper[placement]>boundaries[placement]&&!options.escapeWithReference){value=Math.min(popper[mainSide],boundaries[placement]-(placement==='right'?popper.width:popper.height))}
return defineProperty({},mainSide,value)}};order.forEach(function(placement){var side=['left','top'].indexOf(placement)!==-1?'primary':'secondary';popper=_extends$1({},popper,check[side](placement))});data.offsets.popper=popper;return data}
function shift(data){var placement=data.placement;var basePlacement=placement.split('-')[0];var shiftvariation=placement.split('-')[1];if(shiftvariation){var _data$offsets=data.offsets,reference=_data$offsets.reference,popper=_data$offsets.popper;var isVertical=['bottom','top'].indexOf(basePlacement)!==-1;var side=isVertical?'left':'top';var measurement=isVertical?'width':'height';var shiftOffsets={start:defineProperty({},side,reference[side]),end:defineProperty({},side,reference[side]+reference[measurement]-popper[measurement])};data.offsets.popper=_extends$1({},popper,shiftOffsets[shiftvariation])}
return data}
function hide(data){if(!isModifierRequired(data.instance.modifiers,'hide','preventOverflow')){return data}
var refRect=data.offsets.reference;var bound=find(data.instance.modifiers,function(modifier){return modifier.name==='preventOverflow'}).boundaries;if(refRect.bottom<bound.top||refRect.left>bound.right||refRect.top>bound.bottom||refRect.right<bound.left){if(data.hide===!0){return data}
data.hide=!0;data.attributes['x-out-of-boundaries']=''}else{if(data.hide===!1){return data}
data.hide=!1;data.attributes['x-out-of-boundaries']=!1}
return data}
function inner(data){var placement=data.placement;var basePlacement=placement.split('-')[0];var _data$offsets=data.offsets,popper=_data$offsets.popper,reference=_data$offsets.reference;var isHoriz=['left','right'].indexOf(basePlacement)!==-1;var subtractLength=['top','left'].indexOf(basePlacement)===-1;popper[isHoriz?'left':'top']=reference[basePlacement]-(subtractLength?popper[isHoriz?'width':'height']:0);data.placement=getOppositePlacement(placement);data.offsets.popper=getClientRect(popper);return data}
var modifiers={shift:{order:100,enabled:!0,fn:shift},offset:{order:200,enabled:!0,fn:offset,offset:0},preventOverflow:{order:300,enabled:!0,fn:preventOverflow,priority:['left','right','top','bottom'],padding:5,boundariesElement:'scrollParent'},keepTogether:{order:400,enabled:!0,fn:keepTogether},arrow:{order:500,enabled:!0,fn:arrow,element:'[x-arrow]'},flip:{order:600,enabled:!0,fn:flip,behavior:'flip',padding:5,boundariesElement:'viewport'},inner:{order:700,enabled:!1,fn:inner},hide:{order:800,enabled:!0,fn:hide},computeStyle:{order:850,enabled:!0,fn:computeStyle,gpuAcceleration:!0,x:'bottom',y:'right'},applyStyle:{order:900,enabled:!0,fn:applyStyle,onLoad:applyStyleOnLoad,gpuAcceleration:undefined}};var Defaults={placement:'bottom',eventsEnabled:!0,removeOnDestroy:!1,onCreate:function onCreate(){},onUpdate:function onUpdate(){},modifiers:modifiers};var Popper=function(){function Popper(reference,popper){var _this=this;var options=arguments.length>2&&arguments[2]!==undefined?arguments[2]:{};classCallCheck(this,Popper);this.scheduleUpdate=function(){return requestAnimationFrame(_this.update)};this.update=debounce(this.update.bind(this));this.options=_extends$1({},Popper.Defaults,options);this.state={isDestroyed:!1,isCreated:!1,scrollParents:[]};this.reference=reference&&reference.jquery?reference[0]:reference;this.popper=popper&&popper.jquery?popper[0]:popper;this.options.modifiers={};Object.keys(_extends$1({},Popper.Defaults.modifiers,options.modifiers)).forEach(function(name){_this.options.modifiers[name]=_extends$1({},Popper.Defaults.modifiers[name]||{},options.modifiers?options.modifiers[name]:{})});this.modifiers=Object.keys(this.options.modifiers).map(function(name){return _extends$1({name:name},_this.options.modifiers[name])}).sort(function(a,b){return a.order-b.order});this.modifiers.forEach(function(modifierOptions){if(modifierOptions.enabled&&isFunction(modifierOptions.onLoad)){modifierOptions.onLoad(_this.reference,_this.popper,_this.options,modifierOptions,_this.state)}});this.update();var eventsEnabled=this.options.eventsEnabled;if(eventsEnabled){this.enableEventListeners()}
this.state.eventsEnabled=eventsEnabled}
createClass(Popper,[{key:'update',value:function update$$1(){return update.call(this)}},{key:'destroy',value:function destroy$$1(){return destroy.call(this)}},{key:'enableEventListeners',value:function enableEventListeners$$1(){return enableEventListeners.call(this)}},{key:'disableEventListeners',value:function disableEventListeners$$1(){return disableEventListeners.call(this)}}]);return Popper}();Popper.Utils=(typeof window!=='undefined'?window:global).PopperUtils;Popper.placements=placements;Popper.Defaults=Defaults;var Tooltip=function($$$1){var NAME='tooltip';var VERSION='4.0.0';var DATA_KEY='bs.tooltip';var EVENT_KEY='.'+DATA_KEY;var JQUERY_NO_CONFLICT=$$$1.fn[NAME];var TRANSITION_DURATION=150;var CLASS_PREFIX='bs-tooltip';var BSCLS_PREFIX_REGEX=new RegExp('(^|\\s)'+CLASS_PREFIX+'\\S+','g');var DefaultType={animation:'boolean',template:'string',title:'(string|element|function)',trigger:'string',delay:'(number|object)',html:'boolean',selector:'(string|boolean)',placement:'(string|function)',offset:'(number|string)',container:'(string|element|boolean)',fallbackPlacement:'(string|array)',boundary:'(string|element)'};var AttachmentMap={AUTO:'auto',TOP:'top',RIGHT:'right',BOTTOM:'bottom',LEFT:'left'};var Default={animation:!0,template:'<div class="tooltip" role="tooltip">'+'<div class="arrow"></div>'+'<div class="tooltip-inner"></div></div>',trigger:'hover focus',title:'',delay:0,html:!1,selector:!1,placement:'top',offset:0,container:!1,fallbackPlacement:'flip',boundary:'scrollParent'};var HoverState={SHOW:'show',OUT:'out'};var Event={HIDE:'hide'+EVENT_KEY,HIDDEN:'hidden'+EVENT_KEY,SHOW:'show'+EVENT_KEY,SHOWN:'shown'+EVENT_KEY,INSERTED:'inserted'+EVENT_KEY,CLICK:'click'+EVENT_KEY,FOCUSIN:'focusin'+EVENT_KEY,FOCUSOUT:'focusout'+EVENT_KEY,MOUSEENTER:'mouseenter'+EVENT_KEY,MOUSELEAVE:'mouseleave'+EVENT_KEY};var ClassName={FADE:'fade',SHOW:'show'};var Selector={TOOLTIP:'.tooltip',TOOLTIP_INNER:'.tooltip-inner',ARROW:'.arrow'};var Trigger={HOVER:'hover',FOCUS:'focus',CLICK:'click',MANUAL:'manual'};var Tooltip=function(){function Tooltip(element,config){if(typeof Popper==='undefined'){throw new TypeError('Bootstrap tooltips require Popper.js (https://popper.js.org)')}
this._isEnabled=!0;this._timeout=0;this._hoverState='';this._activeTrigger={};this._popper=null;this.element=element;this.config=this._getConfig(config);this.tip=null;this._setListeners()}
var _proto=Tooltip.prototype;_proto.enable=function enable(){this._isEnabled=!0};_proto.disable=function disable(){this._isEnabled=!1};_proto.toggleEnabled=function toggleEnabled(){this._isEnabled=!this._isEnabled};_proto.toggle=function toggle(event){if(!this._isEnabled){return}
if(event){var dataKey=this.constructor.DATA_KEY;var context=$$$1(event.currentTarget).data(dataKey);if(!context){context=new this.constructor(event.currentTarget,this._getDelegateConfig());$$$1(event.currentTarget).data(dataKey,context)}
context._activeTrigger.click=!context._activeTrigger.click;if(context._isWithActiveTrigger()){context._enter(null,context)}else{context._leave(null,context)}}else{if($$$1(this.getTipElement()).hasClass(ClassName.SHOW)){this._leave(null,this);return}
this._enter(null,this)}};_proto.dispose=function dispose(){clearTimeout(this._timeout);$$$1.removeData(this.element,this.constructor.DATA_KEY);$$$1(this.element).off(this.constructor.EVENT_KEY);$$$1(this.element).closest('.modal').off('hide.bs.modal');if(this.tip){$$$1(this.tip).remove()}
this._isEnabled=null;this._timeout=null;this._hoverState=null;this._activeTrigger=null;if(this._popper!==null){this._popper.destroy()}
this._popper=null;this.element=null;this.config=null;this.tip=null};_proto.show=function show(){var _this=this;if($$$1(this.element).css('display')==='none'){throw new Error('Please use show on visible elements')}
var showEvent=$$$1.Event(this.constructor.Event.SHOW);if(this.isWithContent()&&this._isEnabled){$$$1(this.element).trigger(showEvent);var isInTheDom=$$$1.contains(this.element.ownerDocument.documentElement,this.element);if(showEvent.isDefaultPrevented()||!isInTheDom){return}
var tip=this.getTipElement();var tipId=Util.getUID(this.constructor.NAME);tip.setAttribute('id',tipId);this.element.setAttribute('aria-describedby',tipId);this.setContent();if(this.config.animation){$$$1(tip).addClass(ClassName.FADE)}
var placement=typeof this.config.placement==='function'?this.config.placement.call(this,tip,this.element):this.config.placement;var attachment=this._getAttachment(placement);this.addAttachmentClass(attachment);var container=this.config.container===!1?document.body:$$$1(this.config.container);$$$1(tip).data(this.constructor.DATA_KEY,this);if(!$$$1.contains(this.element.ownerDocument.documentElement,this.tip)){$$$1(tip).appendTo(container)}
$$$1(this.element).trigger(this.constructor.Event.INSERTED);this._popper=new Popper(this.element,tip,{placement:attachment,modifiers:{offset:{offset:this.config.offset},flip:{behavior:this.config.fallbackPlacement},arrow:{element:Selector.ARROW},preventOverflow:{boundariesElement:this.config.boundary}},onCreate:function onCreate(data){if(data.originalPlacement!==data.placement){_this._handlePopperPlacementChange(data)}},onUpdate:function onUpdate(data){_this._handlePopperPlacementChange(data)}});$$$1(tip).addClass(ClassName.SHOW);if('ontouchstart' in document.documentElement){$$$1('body').children().on('mouseover',null,$$$1.noop)}
var complete=function complete(){if(_this.config.animation){_this._fixTransition()}
var prevHoverState=_this._hoverState;_this._hoverState=null;$$$1(_this.element).trigger(_this.constructor.Event.SHOWN);if(prevHoverState===HoverState.OUT){_this._leave(null,_this)}};if(Util.supportsTransitionEnd()&&$$$1(this.tip).hasClass(ClassName.FADE)){$$$1(this.tip).one(Util.TRANSITION_END,complete).emulateTransitionEnd(Tooltip._TRANSITION_DURATION)}else{complete()}}};_proto.hide=function hide(callback){var _this2=this;var tip=this.getTipElement();var hideEvent=$$$1.Event(this.constructor.Event.HIDE);var complete=function complete(){if(_this2._hoverState!==HoverState.SHOW&&tip.parentNode){tip.parentNode.removeChild(tip)}
_this2._cleanTipClass();_this2.element.removeAttribute('aria-describedby');$$$1(_this2.element).trigger(_this2.constructor.Event.HIDDEN);if(_this2._popper!==null){_this2._popper.destroy()}
if(callback){callback()}};$$$1(this.element).trigger(hideEvent);if(hideEvent.isDefaultPrevented()){return}
$$$1(tip).removeClass(ClassName.SHOW);if('ontouchstart' in document.documentElement){$$$1('body').children().off('mouseover',null,$$$1.noop)}
this._activeTrigger[Trigger.CLICK]=!1;this._activeTrigger[Trigger.FOCUS]=!1;this._activeTrigger[Trigger.HOVER]=!1;if(Util.supportsTransitionEnd()&&$$$1(this.tip).hasClass(ClassName.FADE)){$$$1(tip).one(Util.TRANSITION_END,complete).emulateTransitionEnd(TRANSITION_DURATION)}else{complete()}
this._hoverState=''};_proto.update=function update(){if(this._popper!==null){this._popper.scheduleUpdate()}};_proto.isWithContent=function isWithContent(){return Boolean(this.getTitle())};_proto.addAttachmentClass=function addAttachmentClass(attachment){$$$1(this.getTipElement()).addClass(CLASS_PREFIX+'-'+attachment)};_proto.getTipElement=function getTipElement(){this.tip=this.tip||$$$1(this.config.template)[0];return this.tip};_proto.setContent=function setContent(){var $tip=$$$1(this.getTipElement());this.setElementContent($tip.find(Selector.TOOLTIP_INNER),this.getTitle());$tip.removeClass(ClassName.FADE+' '+ClassName.SHOW)};_proto.setElementContent=function setElementContent($element,content){var html=this.config.html;if(typeof content==='object'&&(content.nodeType||content.jquery)){if(html){if(!$$$1(content).parent().is($element)){$element.empty().append(content)}}else{$element.text($$$1(content).text())}}else{$element[html?'html':'text'](content)}};_proto.getTitle=function getTitle(){var title=this.element.getAttribute('data-original-title');if(!title){title=typeof this.config.title==='function'?this.config.title.call(this.element):this.config.title}
return title};_proto._getAttachment=function _getAttachment(placement){return AttachmentMap[placement.toUpperCase()]};_proto._setListeners=function _setListeners(){var _this3=this;var triggers=this.config.trigger.split(' ');triggers.forEach(function(trigger){if(trigger==='click'){$$$1(_this3.element).on(_this3.constructor.Event.CLICK,_this3.config.selector,function(event){return _this3.toggle(event)})}else if(trigger!==Trigger.MANUAL){var eventIn=trigger===Trigger.HOVER?_this3.constructor.Event.MOUSEENTER:_this3.constructor.Event.FOCUSIN;var eventOut=trigger===Trigger.HOVER?_this3.constructor.Event.MOUSELEAVE:_this3.constructor.Event.FOCUSOUT;$$$1(_this3.element).on(eventIn,_this3.config.selector,function(event){return _this3._enter(event)}).on(eventOut,_this3.config.selector,function(event){return _this3._leave(event)})}
$$$1(_this3.element).closest('.modal').on('hide.bs.modal',function(){return _this3.hide()})});if(this.config.selector){this.config=_extends({},this.config,{trigger:'manual',selector:''})}else{this._fixTitle()}};_proto._fixTitle=function _fixTitle(){var titleType=typeof this.element.getAttribute('data-original-title');if(this.element.getAttribute('title')||titleType!=='string'){this.element.setAttribute('data-original-title',this.element.getAttribute('title')||'');this.element.setAttribute('title','')}};_proto._enter=function _enter(event,context){var dataKey=this.constructor.DATA_KEY;context=context||$$$1(event.currentTarget).data(dataKey);if(!context){context=new this.constructor(event.currentTarget,this._getDelegateConfig());$$$1(event.currentTarget).data(dataKey,context)}
if(event){context._activeTrigger[event.type==='focusin'?Trigger.FOCUS:Trigger.HOVER]=!0}
if($$$1(context.getTipElement()).hasClass(ClassName.SHOW)||context._hoverState===HoverState.SHOW){context._hoverState=HoverState.SHOW;return}
clearTimeout(context._timeout);context._hoverState=HoverState.SHOW;if(!context.config.delay||!context.config.delay.show){context.show();return}
context._timeout=setTimeout(function(){if(context._hoverState===HoverState.SHOW){context.show()}},context.config.delay.show)};_proto._leave=function _leave(event,context){var dataKey=this.constructor.DATA_KEY;context=context||$$$1(event.currentTarget).data(dataKey);if(!context){context=new this.constructor(event.currentTarget,this._getDelegateConfig());$$$1(event.currentTarget).data(dataKey,context)}
if(event){context._activeTrigger[event.type==='focusout'?Trigger.FOCUS:Trigger.HOVER]=!1}
if(context._isWithActiveTrigger()){return}
clearTimeout(context._timeout);context._hoverState=HoverState.OUT;if(!context.config.delay||!context.config.delay.hide){context.hide();return}
context._timeout=setTimeout(function(){if(context._hoverState===HoverState.OUT){context.hide()}},context.config.delay.hide)};_proto._isWithActiveTrigger=function _isWithActiveTrigger(){for(var trigger in this._activeTrigger){if(this._activeTrigger[trigger]){return!0}}
return!1};_proto._getConfig=function _getConfig(config){config=_extends({},this.constructor.Default,$$$1(this.element).data(),config);if(typeof config.delay==='number'){config.delay={show:config.delay,hide:config.delay}}
if(typeof config.title==='number'){config.title=config.title.toString()}
if(typeof config.content==='number'){config.content=config.content.toString()}
Util.typeCheckConfig(NAME,config,this.constructor.DefaultType);return config};_proto._getDelegateConfig=function _getDelegateConfig(){var config={};if(this.config){for(var key in this.config){if(this.constructor.Default[key]!==this.config[key]){config[key]=this.config[key]}}}
return config};_proto._cleanTipClass=function _cleanTipClass(){var $tip=$$$1(this.getTipElement());var tabClass=$tip.attr('class').match(BSCLS_PREFIX_REGEX);if(tabClass!==null&&tabClass.length>0){$tip.removeClass(tabClass.join(''))}};_proto._handlePopperPlacementChange=function _handlePopperPlacementChange(data){this._cleanTipClass();this.addAttachmentClass(this._getAttachment(data.placement))};_proto._fixTransition=function _fixTransition(){var tip=this.getTipElement();var initConfigAnimation=this.config.animation;if(tip.getAttribute('x-placement')!==null){return}
$$$1(tip).removeClass(ClassName.FADE);this.config.animation=!1;this.hide();this.show();this.config.animation=initConfigAnimation};Tooltip._jQueryInterface=function _jQueryInterface(config){return this.each(function(){var data=$$$1(this).data(DATA_KEY);var _config=typeof config==='object'&&config;if(!data&&/dispose|hide/.test(config)){return}
if(!data){data=new Tooltip(this,_config);$$$1(this).data(DATA_KEY,data)}
if(typeof config==='string'){if(typeof data[config]==='undefined'){throw new TypeError('No method named "'+config+'"')}
data[config]()}})};_createClass(Tooltip,null,[{key:'VERSION',get:function get(){return VERSION}},{key:'Default',get:function get(){return Default}},{key:'NAME',get:function get(){return NAME}},{key:'DATA_KEY',get:function get(){return DATA_KEY}},{key:'Event',get:function get(){return Event}},{key:'EVENT_KEY',get:function get(){return EVENT_KEY}},{key:'DefaultType',get:function get(){return DefaultType}}]);return Tooltip}();$$$1.fn[NAME]=Tooltip._jQueryInterface;$$$1.fn[NAME].Constructor=Tooltip;$$$1.fn[NAME].noConflict=function(){$$$1.fn[NAME]=JQUERY_NO_CONFLICT;return Tooltip._jQueryInterface};return Tooltip}($,Popper);(function($$$1){if(typeof $$$1==='undefined'){throw new TypeError('Bootstrap\'s JavaScript requires jQuery. jQuery must be included before Bootstrap\'s JavaScript.')}
var version=$$$1.fn.jquery.split(' ')[0].split('.');var minMajor=1;var ltMajor=2;var minMinor=9;var minPatch=1;var maxMajor=4;if(version[0]<ltMajor&&version[1]<minMinor||version[0]===minMajor&&version[1]===minMinor&&version[2]<minPatch||version[0]>=maxMajor){throw new Error('Bootstrap\'s JavaScript requires at least jQuery v1.9.1 but less than v4.0.0')}})($);exports.Util=Util;exports.Tooltip=Tooltip;Object.defineProperty(exports,'__esModule',{value:!0})})))